/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.tls.IdentifierType;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TrustedAuthority {
    protected short identifierType;
    protected Object identifier;

    public TrustedAuthority(short s, Object object) {
        if (!TrustedAuthority.isCorrectType(s, object)) {
            throw new IllegalArgumentException("'identifier' is not an instance of the correct type");
        }
        this.identifierType = s;
        this.identifier = object;
    }

    public short getIdentifierType() {
        return this.identifierType;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public byte[] getCertSHA1Hash() {
        return Arrays.clone((byte[])this.identifier);
    }

    public byte[] getKeySHA1Hash() {
        return Arrays.clone((byte[])this.identifier);
    }

    public X500Name getX509Name() {
        this.checkCorrectType((short)2);
        return (X500Name)this.identifier;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.identifierType, outputStream);
        switch (this.identifierType) {
            case 1: 
            case 3: {
                byte[] byArray = (byte[])this.identifier;
                outputStream.write(byArray);
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                X500Name x500Name = (X500Name)this.identifier;
                byte[] byArray = x500Name.getEncoded("DER");
                TlsUtils.writeOpaque16(byArray, outputStream);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static TrustedAuthority parse(InputStream inputStream) throws IOException {
        Object object;
        short s = TlsUtils.readUint8(inputStream);
        switch (s) {
            case 1: 
            case 3: {
                object = TlsUtils.readFully(20, inputStream);
                break;
            }
            case 0: {
                object = null;
                break;
            }
            case 2: {
                byte[] byArray = TlsUtils.readOpaque16(inputStream, 1);
                ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(byArray);
                X500Name x500Name = X500Name.getInstance(aSN1Primitive);
                TlsUtils.requireDEREncoding(x500Name, byArray);
                object = x500Name;
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new TrustedAuthority(s, object);
    }

    protected void checkCorrectType(short s) {
        if (this.identifierType != s || !TrustedAuthority.isCorrectType(s, this.identifier)) {
            throw new IllegalStateException("TrustedAuthority is not of type " + IdentifierType.getName(s));
        }
    }

    protected static boolean isCorrectType(short s, Object object) {
        switch (s) {
            case 1: 
            case 3: {
                return TrustedAuthority.isSHA1Hash(object);
            }
            case 0: {
                return object == null;
            }
            case 2: {
                return object instanceof X500Name;
            }
        }
        throw new IllegalArgumentException("'identifierType' is an unsupported IdentifierType");
    }

    protected static boolean isSHA1Hash(Object object) {
        return object instanceof byte[] && ((byte[])object).length == 20;
    }
}

