/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes;

import com.github.weisj.jsvg.attributes.SpreadMethod;
import com.github.weisj.jsvg.attributes.UnitType;
import com.github.weisj.jsvg.attributes.paint.PaintParser;
import com.github.weisj.jsvg.attributes.paint.SVGPaint;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.Stop;
import com.github.weisj.jsvg.nodes.container.ContainerNode;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.GraphicsUtil;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractGradient<Self extends AbstractGradient<Self>>
extends ContainerNode
implements SVGPaint {
    protected AffineTransform gradientTransform;
    protected UnitType gradientUnits;
    protected SpreadMethod spreadMethod;
    @NotNull
    private Color[] colors;
    private float[] offsets;

    AbstractGradient() {
    }

    public final float[] offsets() {
        return this.offsets;
    }

    @NotNull
    public final Color[] colors() {
        return this.colors;
    }

    @Override
    public final void build(@NotNull AttributeNode attributeNode) {
        List<Stop> stops;
        super.build(attributeNode);
        AbstractGradient<?> template = this.parseTemplate(attributeNode);
        this.gradientUnits = attributeNode.getEnum("gradientUnits", template != null ? template.gradientUnits : UnitType.ObjectBoundingBox);
        this.spreadMethod = attributeNode.getEnum("spreadMethod", template != null ? template.spreadMethod : SpreadMethod.Pad);
        this.gradientTransform = attributeNode.parseTransform("gradientTransform");
        if (this.gradientTransform == null && template != null) {
            this.gradientTransform = template.gradientTransform;
        }
        if ((stops = this.childrenOfType(Stop.class)).isEmpty() && template != null) {
            this.colors = template.colors();
            this.offsets = template.offsets();
        } else {
            this.parseStops(stops);
        }
        AbstractGradient<?> selfTemplate = this.getClass().isInstance(template) ? template : null;
        this.buildGradient(attributeNode, selfTemplate);
        this.children().clear();
    }

    private void parseStops(@NotNull List<Stop> stops) {
        stops.sort((s1, s2) -> Float.compare(s1.offset(), s2.offset()));
        this.colors = new Color[stops.size()];
        this.offsets = new float[stops.size()];
        boolean realGradient = false;
        for (int i = 0; i < this.offsets.length; ++i) {
            Stop stop = stops.get(i);
            float stopOffset = Math.max(0.0f, Math.min(1.0f, stop.offset()));
            Color stopColor = stop.color();
            if (i > 0) {
                boolean bl = realGradient = realGradient || stopOffset > stops.get(i - 1).offset() || !stopColor.equals(this.colors[i - 1]);
                if (stopOffset <= this.offsets[i - 1]) {
                    stopOffset = Math.nextAfter(this.offsets[i - 1], Double.MAX_VALUE);
                }
            }
            this.offsets[i] = stopOffset;
            this.colors[i] = stopColor;
        }
        if (this.offsets[this.offsets.length - 1] > 1.0f) {
            float diff = this.offsets[this.offsets.length - 1] - 1.0f;
            this.offsets[this.offsets.length - 1] = 1.0f;
            int i = this.offsets.length - 2;
            while (i >= 0 && this.offsets[i] >= this.offsets[i + 1]) {
                int n = i;
                this.offsets[n] = this.offsets[n] - diff;
            }
        }
        if (!realGradient && this.colors.length > 0) {
            this.colors = new Color[]{this.colors[0]};
            this.offsets = new float[]{0.0f};
        } else {
            int offsetLength = this.offsets.length;
            int off = 0;
            boolean fixFirst = false;
            boolean fixLast = false;
            if (this.offsets[0] != 0.0f) {
                fixFirst = true;
                ++offsetLength;
                ++off;
            }
            if (this.offsets[this.offsets.length - 1] != 1.0f) {
                fixLast = true;
                ++offsetLength;
            }
            float[] oldOffsets = this.offsets;
            Color[] oldColors = this.colors;
            this.offsets = new float[offsetLength];
            this.colors = new Color[offsetLength];
            System.arraycopy(oldOffsets, 0, this.offsets, off, oldOffsets.length);
            System.arraycopy(oldColors, 0, this.colors, off, oldColors.length);
            if (fixFirst) {
                this.offsets[0] = 0.0f;
                this.colors[0] = oldColors[0];
            }
            if (fixLast) {
                this.offsets[offsetLength - 1] = 1.0f;
                this.colors[offsetLength - 1] = oldColors[oldColors.length - 1];
            }
        }
    }

    @Nullable
    private AbstractGradient<?> parseTemplate(@NotNull AttributeNode attributeNode) {
        AbstractGradient<Self> template = attributeNode.getElementByHref(AbstractGradient.class, attributeNode.getHref());
        return template != this ? template : null;
    }

    protected abstract void buildGradient(@NotNull AttributeNode var1, @Nullable Self var2);

    @Override
    public void fillShape(@NotNull Graphics2D g, @NotNull RenderContext context, @NotNull Shape shape, @Nullable Rectangle2D bounds) {
        Rectangle2D b = bounds != null ? bounds : shape.getBounds2D();
        GraphicsUtil.safelySetPaint(g, this.paintForBounds(context.measureContext(), b));
        g.fill(shape);
    }

    @Override
    public void drawShape(@NotNull Graphics2D g, @NotNull RenderContext context, @NotNull Shape shape, @Nullable Rectangle2D bounds) {
        Rectangle2D b = bounds != null ? bounds : shape.getBounds2D();
        GraphicsUtil.safelySetPaint(g, this.paintForBounds(context.measureContext(), b));
        g.draw(shape);
    }

    @NotNull
    private Paint paintForBounds(@NotNull MeasureContext context, @NotNull Rectangle2D bounds) {
        Color[] gradColors = this.colors();
        if (gradColors.length == 0) {
            return PaintParser.DEFAULT_COLOR;
        }
        if (gradColors.length == 1) {
            return gradColors[0];
        }
        return this.gradientForBounds(this.gradientUnits.deriveMeasure(context), bounds, this.offsets(), gradColors);
    }

    @NotNull
    protected abstract Paint gradientForBounds(@NotNull MeasureContext var1, @NotNull Rectangle2D var2, float[] var3, @NotNull Color[] var4);

    @NotNull
    protected final AffineTransform computeViewTransform(@NotNull Rectangle2D bounds) {
        AffineTransform viewTransform = this.gradientUnits.viewTransform(bounds);
        if (this.gradientTransform != null) {
            viewTransform.concatenate(this.gradientTransform);
        }
        return viewTransform;
    }
}

