/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.discord;

import com.google.common.base.Strings;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import lombok.Generated;
import net.runelite.client.discord.DiscordPresence;
import net.runelite.client.discord.events.DiscordDisconnected;
import net.runelite.client.discord.events.DiscordErrored;
import net.runelite.client.discord.events.DiscordJoinGame;
import net.runelite.client.discord.events.DiscordJoinRequest;
import net.runelite.client.discord.events.DiscordReady;
import net.runelite.client.discord.events.DiscordSpectateGame;
import net.runelite.client.eventbus.EventBus;
import net.runelite.discord.DiscordEventHandlers;
import net.runelite.discord.DiscordRPC;
import net.runelite.discord.DiscordRichPresence;
import net.runelite.discord.DiscordUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DiscordService
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiscordService.class);
    private final EventBus eventBus;
    private final ScheduledExecutorService executorService;
    private final String discordAppId;
    private final DiscordRPC discordRPC;
    private DiscordEventHandlers discordEventHandlers;
    private DiscordUser currentUser;

    @Inject
    DiscordService(EventBus eventBus, ScheduledExecutorService executorService, @Named(value="runelite.discord.enable") boolean enable, @Named(value="runelite.discord.appid") String discordAppId) {
        DiscordRPC rpc;
        this.eventBus = eventBus;
        this.executorService = executorService;
        this.discordAppId = discordAppId;
        if (!enable) {
            this.discordRPC = null;
            log.info("Discord RPC disabled via config.");
            return;
        }
        try {
            rpc = DiscordRPC.INSTANCE;
        }
        catch (Error e) {
            log.warn("Failed to load Discord RPC library, disabling Discord support.");
            this.discordRPC = null;
            return;
        }
        this.discordRPC = rpc;
    }

    public void init() {
        if (this.discordRPC == null) {
            return;
        }
        log.info("Initializing Discord RPC with App ID: {}", (Object)this.discordAppId);
        this.discordEventHandlers = new DiscordEventHandlers();
        this.discordEventHandlers.ready = this::ready;
        this.discordEventHandlers.disconnected = this::disconnected;
        this.discordEventHandlers.errored = this::errored;
        this.discordEventHandlers.joinGame = this::joinGame;
        this.discordEventHandlers.spectateGame = this::spectateGame;
        this.discordEventHandlers.joinRequest = this::joinRequest;
        this.discordRPC.Discord_Initialize(this.discordAppId, this.discordEventHandlers, true, null);
        this.executorService.scheduleAtFixedRate(this.discordRPC::Discord_RunCallbacks, 0L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (this.discordRPC != null) {
            log.info("Shutting down Discord RPC.");
            this.discordRPC.Discord_Shutdown();
        }
    }

    public void updatePresence(DiscordPresence discordPresence) {
        if (this.discordRPC == null) {
            return;
        }
        DiscordRichPresence rpcPresence = new DiscordRichPresence();
        rpcPresence.state = discordPresence.getState();
        rpcPresence.details = discordPresence.getDetails();
        rpcPresence.startTimestamp = discordPresence.getStartTimestamp() != null ? discordPresence.getStartTimestamp().getEpochSecond() : 0L;
        rpcPresence.endTimestamp = discordPresence.getEndTimestamp() != null ? discordPresence.getEndTimestamp().getEpochSecond() : 0L;
        rpcPresence.largeImageKey = Strings.isNullOrEmpty(discordPresence.getLargeImageKey()) ? "default" : discordPresence.getLargeImageKey();
        rpcPresence.largeImageText = discordPresence.getLargeImageText();
        if (!Strings.isNullOrEmpty(discordPresence.getSmallImageKey())) {
            rpcPresence.smallImageKey = discordPresence.getSmallImageKey();
            rpcPresence.smallImageText = discordPresence.getSmallImageText();
        }
        rpcPresence.partyId = discordPresence.getPartyId();
        rpcPresence.partySize = discordPresence.getPartySize();
        rpcPresence.partyMax = discordPresence.getPartyMax();
        rpcPresence.matchSecret = discordPresence.getMatchSecret();
        rpcPresence.joinSecret = discordPresence.getJoinSecret();
        rpcPresence.spectateSecret = discordPresence.getSpectateSecret();
        rpcPresence.instance = (byte)(discordPresence.isInstance() ? 1 : 0);
        log.debug("Updating Discord presence: {}", (Object)discordPresence);
        this.discordRPC.Discord_UpdatePresence(rpcPresence);
    }

    public void clearPresence() {
        if (this.discordRPC != null) {
            this.discordRPC.Discord_ClearPresence();
        }
    }

    public void respondToRequest(String userId, int reply) {
        if (this.discordRPC != null) {
            this.discordRPC.Discord_Respond(userId, reply);
        }
    }

    private void ready(DiscordUser user) {
        log.info("Discord RPC ready as {}#{}", (Object)user.username, (Object)user.discriminator);
        this.currentUser = user;
        this.eventBus.post(new DiscordReady(user.userId, user.username, user.discriminator, user.avatar));
    }

    private void disconnected(int errorCode, String message) {
        log.debug("Discord disconnected {}: {}", (Object)errorCode, (Object)message);
        this.eventBus.post(new DiscordDisconnected(errorCode, message));
    }

    private void errored(int errorCode, String message) {
        log.warn("Discord error {}: {}", (Object)errorCode, (Object)message);
        this.eventBus.post(new DiscordErrored(errorCode, message));
    }

    private void joinGame(String joinSecret) {
        this.eventBus.post(new DiscordJoinGame(joinSecret));
    }

    private void spectateGame(String spectateSecret) {
        this.eventBus.post(new DiscordSpectateGame(spectateSecret));
    }

    private void joinRequest(DiscordUser user) {
        this.eventBus.post(new DiscordJoinRequest(user.userId, user.username, user.discriminator, user.avatar));
    }

    @Generated
    public DiscordUser getCurrentUser() {
        return this.currentUser;
    }
}

