/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.discord;

import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameTick;
import net.runelite.client.discord.DiscordPresence;
import net.runelite.client.discord.DiscordService;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class FateDiscordPresenceListener {
    @Inject
    private Client client;
    @Inject
    private DiscordService discordService;
    private boolean presenceSet = false;

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            if (!this.presenceSet) {
                DiscordPresence presence = DiscordPresence.builder().state("Playing Fate RSPS").details("PvP \u2022 PvM \u2022 Ironman").largeImageKey("fate_logo").largeImageText("Fate RSPS").startTimestamp(Instant.now()).build();
                this.discordService.updatePresence(presence);
                this.presenceSet = true;
            }
        } else if (this.presenceSet) {
            this.discordService.clearPresence();
            this.presenceSet = false;
        }
    }
}

