/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.ping;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ping.Ping;
import net.runelite.client.plugins.ping.PingSupplier;
import net.runelite.client.plugins.ping.PingThread;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PingPanel
extends PluginPanel {
    private static final long PING_INTERVAL_MS = 3000L;
    private static final String ICMP_PING_TITLE = "ICMP ping: ";
    private static final String TOTAL_PING_TITLE = "Total ping: ";
    private static final Logger log = LoggerFactory.getLogger(PingPanel.class);
    private volatile PingThread icmpPingThread;
    private volatile PingThread totalPingThread;

    PingPanel() {
    }

    private static String toHex(int value) {
        String hex = Integer.toHexString(value & 0xFF);
        return hex.length() == 1 ? "0" + hex : hex;
    }

    private static String getColor(long value) {
        if (value <= 0L) {
            return "#00FF00";
        }
        if (value >= 255L) {
            return "#FF0000";
        }
        int red = (int)value;
        int green = (int)(255L - value);
        boolean blue = false;
        return "#" + PingPanel.toHex(red) + PingPanel.toHex(green) + PingPanel.toHex(0);
    }

    private static String pingStatus(long ms) {
        String color = PingPanel.getColor(ms);
        return "<span style = 'color:" + color + "'>" + ms + "ms</span>";
    }

    private static void updatePingLabel(String title, JLabel label, PingSupplier pingSupplier) {
        String status = "<span style = 'color:red'>DISCONNECTED</span>";
        try {
            long pingNs = pingSupplier.getPingNs();
            if (pingNs >= 0L) {
                long pingMs = TimeUnit.NANOSECONDS.toMillis(pingNs);
                status = PingPanel.pingStatus(pingMs);
            }
        }
        catch (Exception e) {
            log.error("Error updating ping", e);
        }
        String text = "<html><body style = 'color:#a5a5a5'>" + title + "<span style = 'color:white'>" + status + "</span></body></html>";
        label.setText(text);
    }

    void init() {
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel sidePanel = new JPanel();
        sidePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        sidePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        sidePanel.setLayout(new GridLayout(0, 1));
        Font smallFont = FontManager.getRunescapeSmallFont();
        JLabel icmpPingLabel = new JLabel();
        icmpPingLabel.setFont(smallFont);
        icmpPingLabel.setToolTipText("Does not account for routing or server processing time");
        JLabel totalPingLabel = new JLabel();
        totalPingLabel.setFont(smallFont);
        totalPingLabel.setToolTipText("Includes routing and server processing time");
        String host = "148.113.201.156";
        int port = 43594;
        PingSupplier icmpPingSupplier = () -> Ping.ping("148.113.201.156", 43594);
        this.icmpPingThread = new PingThread(3000L, () -> PingPanel.updatePingLabel(ICMP_PING_TITLE, icmpPingLabel, icmpPingSupplier));
        this.icmpPingThread.setRunning(true);
        this.totalPingThread.setRunning(true);
        this.icmpPingThread.start();
        this.totalPingThread.start();
        sidePanel.add(icmpPingLabel);
        sidePanel.add(totalPingLabel);
        this.add((Component)sidePanel, "North");
    }

    void deinit() {
        PingThread totalPingThread;
        PingThread icmpPingThread = this.icmpPingThread;
        if (icmpPingThread != null) {
            icmpPingThread.setRunning(false);
            this.icmpPingThread = null;
        }
        if ((totalPingThread = this.totalPingThread) != null) {
            totalPingThread.setRunning(false);
            this.totalPingThread = null;
        }
    }
}

