/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay.infobox;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.infobox.InfoBoxPriority;

public abstract class InfoBox {
    @Nonnull
    private final Plugin plugin;
    private BufferedImage image;
    private BufferedImage scaledImage;
    private InfoBoxPriority priority;
    private String tooltip;
    private List<OverlayMenuEntry> menuEntries = new ArrayList<OverlayMenuEntry>();
    String layer;

    public InfoBox(BufferedImage image, @Nonnull Plugin plugin) {
        this.plugin = plugin;
        this.setImage(image);
        this.setPriority(InfoBoxPriority.NONE);
    }

    public abstract String getText();

    public abstract Color getTextColor();

    public boolean render() {
        return true;
    }

    public boolean cull() {
        return false;
    }

    public String getName() {
        return this.plugin.getClass().getSimpleName() + "_" + this.getClass().getSimpleName();
    }

    @Nonnull
    @Generated
    Plugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public BufferedImage getImage() {
        return this.image;
    }

    @Generated
    public void setImage(BufferedImage image) {
        this.image = image;
    }

    @Generated
    BufferedImage getScaledImage() {
        return this.scaledImage;
    }

    @Generated
    void setScaledImage(BufferedImage scaledImage) {
        this.scaledImage = scaledImage;
    }

    @Generated
    InfoBoxPriority getPriority() {
        return this.priority;
    }

    @Generated
    public void setPriority(InfoBoxPriority priority) {
        this.priority = priority;
    }

    @Generated
    public String getTooltip() {
        return this.tooltip;
    }

    @Generated
    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    @Generated
    public List<OverlayMenuEntry> getMenuEntries() {
        return this.menuEntries;
    }

    @Generated
    public void setMenuEntries(List<OverlayMenuEntry> menuEntries) {
        this.menuEntries = menuEntries;
    }
}

