/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DTLSProtocol;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HeartbeatExtension;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.OfferedPsks;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContextImpl;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHeartbeat;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.util.Arrays;

public class DTLSClientProtocol
extends DTLSProtocol {
    public DTLSTransport connect(TlsClient tlsClient, DatagramTransport datagramTransport) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        if (datagramTransport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        TlsClientContextImpl tlsClientContextImpl = new TlsClientContextImpl(tlsClient.getCrypto());
        ClientHandshakeState clientHandshakeState = new ClientHandshakeState();
        clientHandshakeState.client = tlsClient;
        clientHandshakeState.clientContext = tlsClientContextImpl;
        tlsClient.init(tlsClientContextImpl);
        tlsClientContextImpl.handshakeBeginning(tlsClient);
        SecurityParameters securityParameters = tlsClientContextImpl.getSecurityParametersHandshake();
        securityParameters.extendedPadding = tlsClient.shouldUseExtendedPadding();
        DTLSRecordLayer dTLSRecordLayer = new DTLSRecordLayer(tlsClientContextImpl, tlsClient, datagramTransport);
        tlsClient.notifyCloseHandle(dTLSRecordLayer);
        try {
            DTLSTransport dTLSTransport = this.clientHandshake(clientHandshakeState, dTLSRecordLayer);
            return dTLSTransport;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortClientHandshake(clientHandshakeState, dTLSRecordLayer, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortClientHandshake(clientHandshakeState, dTLSRecordLayer, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortClientHandshake(clientHandshakeState, dTLSRecordLayer, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.clear();
        }
    }

    protected void abortClientHandshake(ClientHandshakeState clientHandshakeState, DTLSRecordLayer dTLSRecordLayer, short s) {
        dTLSRecordLayer.fail(s);
        this.invalidateSession(clientHandshakeState);
    }

    protected DTLSTransport clientHandshake(ClientHandshakeState clientHandshakeState, DTLSRecordLayer dTLSRecordLayer) throws IOException {
        byte[] byArray;
        Object object;
        Object object2;
        TlsClient tlsClient = clientHandshakeState.client;
        TlsClientContextImpl tlsClientContextImpl = clientHandshakeState.clientContext;
        SecurityParameters securityParameters = tlsClientContextImpl.getSecurityParametersHandshake();
        DTLSReliableHandshake dTLSReliableHandshake = new DTLSReliableHandshake(tlsClientContextImpl, dTLSRecordLayer, tlsClient.getHandshakeTimeoutMillis(), tlsClient.getHandshakeResendTimeMillis(), null);
        byte[] byArray2 = this.generateClientHello(clientHandshakeState);
        dTLSRecordLayer.setWriteVersion(ProtocolVersion.DTLSv10);
        dTLSReliableHandshake.sendMessage((short)1, byArray2);
        DTLSReliableHandshake.Message message = dTLSReliableHandshake.receiveMessage();
        while (message.getType() == 3) {
            object2 = this.processHelloVerifyRequest(clientHandshakeState, message.getBody());
            object = DTLSClientProtocol.patchClientHelloWithCookie(byArray2, (byte[])object2);
            dTLSReliableHandshake.resetAfterHelloVerifyRequestClient();
            dTLSReliableHandshake.sendMessage((short)1, (byte[])object);
            message = dTLSReliableHandshake.receiveMessage();
        }
        if (message.getType() != 2) {
            throw new TlsFatalAlert(10);
        }
        object2 = dTLSRecordLayer.getReadVersion();
        this.reportServerVersion(clientHandshakeState, (ProtocolVersion)object2);
        dTLSRecordLayer.setWriteVersion((ProtocolVersion)object2);
        this.processServerHello(clientHandshakeState, message.getBody());
        DTLSClientProtocol.applyMaxFragmentLengthExtension(dTLSRecordLayer, securityParameters.getMaxFragmentLength());
        dTLSReliableHandshake.getHandshakeHash().notifyPRFDetermined();
        if (securityParameters.isResumedSession()) {
            securityParameters.masterSecret = clientHandshakeState.sessionMasterSecret;
            dTLSRecordLayer.initPendingEpoch(TlsUtils.initCipher(tlsClientContextImpl));
            securityParameters.peerVerifyData = TlsUtils.calculateVerifyData(tlsClientContextImpl, dTLSReliableHandshake.getHandshakeHash(), true);
            this.processFinished(dTLSReliableHandshake.receiveMessageBody((short)20), securityParameters.getPeerVerifyData());
            securityParameters.localVerifyData = TlsUtils.calculateVerifyData(tlsClientContextImpl, dTLSReliableHandshake.getHandshakeHash(), false);
            dTLSReliableHandshake.sendMessage((short)20, securityParameters.getLocalVerifyData());
            dTLSReliableHandshake.finish();
            if (securityParameters.isExtendedMasterSecret()) {
                securityParameters.tlsUnique = securityParameters.getPeerVerifyData();
            }
            securityParameters.localCertificate = clientHandshakeState.sessionParameters.getLocalCertificate();
            securityParameters.peerCertificate = clientHandshakeState.sessionParameters.getPeerCertificate();
            securityParameters.pskIdentity = clientHandshakeState.sessionParameters.getPSKIdentity();
            securityParameters.srpIdentity = clientHandshakeState.sessionParameters.getSRPIdentity();
            tlsClientContextImpl.handshakeComplete(tlsClient, clientHandshakeState.tlsSession);
            dTLSRecordLayer.initHeartbeat(clientHandshakeState.heartbeat, 1 == clientHandshakeState.heartbeatPolicy);
            return new DTLSTransport(dTLSRecordLayer);
        }
        this.invalidateSession(clientHandshakeState);
        clientHandshakeState.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
        message = dTLSReliableHandshake.receiveMessage();
        if (message.getType() == 23) {
            this.processServerSupplementalData(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            tlsClient.processServerSupplementalData(null);
        }
        clientHandshakeState.keyExchange = TlsUtils.initKeyExchangeClient(tlsClientContextImpl, tlsClient);
        if (message.getType() == 11) {
            this.processServerCertificate(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            clientHandshakeState.authentication = null;
        }
        if (message.getType() == 22) {
            if (securityParameters.getStatusRequestVersion() < 1) {
                throw new TlsFatalAlert(10);
            }
            this.processCertificateStatus(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        }
        TlsUtils.processServerCertificate(tlsClientContextImpl, clientHandshakeState.certificateStatus, clientHandshakeState.keyExchange, clientHandshakeState.authentication, clientHandshakeState.clientExtensions, clientHandshakeState.serverExtensions);
        if (message.getType() == 12) {
            this.processServerKeyExchange(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            clientHandshakeState.keyExchange.skipServerKeyExchange();
        }
        if (message.getType() == 13) {
            this.processCertificateRequest(clientHandshakeState, message.getBody());
            TlsUtils.establishServerSigAlgs(securityParameters, clientHandshakeState.certificateRequest);
            message = dTLSReliableHandshake.receiveMessage();
        }
        if (message.getType() == 14) {
            if (message.getBody().length != 0) {
                throw new TlsFatalAlert(50);
            }
        } else {
            throw new TlsFatalAlert(10);
        }
        object2 = null;
        object = null;
        Certificate certificate = null;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        TlsStreamSigner tlsStreamSigner = null;
        if (clientHandshakeState.certificateRequest != null && (object2 = (Object)TlsUtils.establishClientCredentials(clientHandshakeState.authentication, clientHandshakeState.certificateRequest)) != null) {
            certificate = object2.getCertificate();
            if (object2 instanceof TlsCredentialedSigner) {
                object = (TlsCredentialedSigner)object2;
                signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(securityParameters.getNegotiatedVersion(), (TlsCredentialedSigner)object);
                tlsStreamSigner = object.getStreamSigner();
                if (ProtocolVersion.DTLSv12.equals(securityParameters.getNegotiatedVersion())) {
                    TlsUtils.verifySupportedSignatureAlgorithm(securityParameters.getServerSigAlgs(), signatureAndHashAlgorithm, (short)80);
                    if (tlsStreamSigner == null) {
                        TlsUtils.trackHashAlgorithmClient(dTLSReliableHandshake.getHandshakeHash(), signatureAndHashAlgorithm);
                    }
                }
                if (tlsStreamSigner != null) {
                    dTLSReliableHandshake.getHandshakeHash().forceBuffering();
                }
            }
        }
        dTLSReliableHandshake.getHandshakeHash().sealHashAlgorithms();
        if (object2 == null) {
            clientHandshakeState.keyExchange.skipClientCredentials();
        } else {
            clientHandshakeState.keyExchange.processClientCredentials((TlsCredentials)object2);
        }
        Vector vector = tlsClient.getClientSupplementalData();
        if (vector != null) {
            byArray = DTLSClientProtocol.generateSupplementalData(vector);
            dTLSReliableHandshake.sendMessage((short)23, byArray);
        }
        if (null != clientHandshakeState.certificateRequest) {
            DTLSClientProtocol.sendCertificateMessage(tlsClientContextImpl, dTLSReliableHandshake, certificate, null);
        }
        byArray = this.generateClientKeyExchange(clientHandshakeState);
        dTLSReliableHandshake.sendMessage((short)16, byArray);
        securityParameters.sessionHash = TlsUtils.getCurrentPRFHash(dTLSReliableHandshake.getHandshakeHash());
        TlsProtocol.establishMasterSecret(tlsClientContextImpl, clientHandshakeState.keyExchange);
        dTLSRecordLayer.initPendingEpoch(TlsUtils.initCipher(tlsClientContextImpl));
        if (object != null) {
            DigitallySigned digitallySigned = TlsUtils.generateCertificateVerifyClient(tlsClientContextImpl, (TlsCredentialedSigner)object, signatureAndHashAlgorithm, tlsStreamSigner, dTLSReliableHandshake.getHandshakeHash());
            byte[] byArray3 = this.generateCertificateVerify(clientHandshakeState, digitallySigned);
            dTLSReliableHandshake.sendMessage((short)15, byArray3);
        }
        dTLSReliableHandshake.prepareToFinish();
        securityParameters.localVerifyData = TlsUtils.calculateVerifyData(tlsClientContextImpl, dTLSReliableHandshake.getHandshakeHash(), false);
        dTLSReliableHandshake.sendMessage((short)20, securityParameters.getLocalVerifyData());
        if (clientHandshakeState.expectSessionTicket) {
            message = dTLSReliableHandshake.receiveMessage();
            if (message.getType() == 4) {
                securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
                this.invalidateSession(clientHandshakeState);
                clientHandshakeState.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
                this.processNewSessionTicket(clientHandshakeState, message.getBody());
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        securityParameters.peerVerifyData = TlsUtils.calculateVerifyData(tlsClientContextImpl, dTLSReliableHandshake.getHandshakeHash(), true);
        this.processFinished(dTLSReliableHandshake.receiveMessageBody((short)20), securityParameters.getPeerVerifyData());
        dTLSReliableHandshake.finish();
        clientHandshakeState.sessionMasterSecret = securityParameters.getMasterSecret();
        clientHandshakeState.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setExtendedMasterSecret(securityParameters.isExtendedMasterSecret()).setLocalCertificate(securityParameters.getLocalCertificate()).setMasterSecret(tlsClientContextImpl.getCrypto().adoptSecret(clientHandshakeState.sessionMasterSecret)).setNegotiatedVersion(securityParameters.getNegotiatedVersion()).setPeerCertificate(securityParameters.getPeerCertificate()).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(clientHandshakeState.serverExtensions).build();
        clientHandshakeState.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), clientHandshakeState.sessionParameters);
        securityParameters.tlsUnique = securityParameters.getLocalVerifyData();
        tlsClientContextImpl.handshakeComplete(tlsClient, clientHandshakeState.tlsSession);
        dTLSRecordLayer.initHeartbeat(clientHandshakeState.heartbeat, 1 == clientHandshakeState.heartbeatPolicy);
        return new DTLSTransport(dTLSRecordLayer);
    }

    protected byte[] generateCertificateVerify(ClientHandshakeState clientHandshakeState, DigitallySigned digitallySigned) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        digitallySigned.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientHello(ClientHandshakeState clientHandshakeState) throws IOException {
        boolean bl;
        TlsClient tlsClient = clientHandshakeState.client;
        TlsClientContextImpl tlsClientContextImpl = clientHandshakeState.clientContext;
        SecurityParameters securityParameters = tlsClientContextImpl.getSecurityParametersHandshake();
        ProtocolVersion[] protocolVersionArray = tlsClient.getProtocolVersions();
        ProtocolVersion protocolVersion = ProtocolVersion.getEarliestDTLS(protocolVersionArray);
        ProtocolVersion protocolVersion2 = ProtocolVersion.getLatestDTLS(protocolVersionArray);
        if (!ProtocolVersion.isSupportedDTLSVersionClient(protocolVersion2)) {
            throw new TlsFatalAlert(80);
        }
        tlsClientContextImpl.setClientVersion(protocolVersion2);
        tlsClientContextImpl.setClientSupportedVersions(protocolVersionArray);
        boolean bl2 = ProtocolVersion.DTLSv12.isEqualOrLaterVersionOf(protocolVersion);
        boolean bl3 = ProtocolVersion.DTLSv13.isEqualOrEarlierVersionOf(protocolVersion2);
        boolean bl4 = !bl3 && tlsClient.shouldUseGMTUnixTime();
        securityParameters.clientRandom = TlsProtocol.createRandomBlock(bl4, tlsClientContextImpl);
        TlsSession tlsSession = bl2 ? tlsClient.getSessionToResume() : null;
        clientHandshakeState.offeredCipherSuites = tlsClient.getCipherSuites();
        boolean bl5 = tlsClient.isFallback();
        clientHandshakeState.clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(tlsClient.getClientExtensions());
        boolean bl6 = tlsClient.shouldUseExtendedMasterSecret();
        this.establishSession(clientHandshakeState, tlsSession);
        byte[] byArray = TlsUtils.getSessionID(clientHandshakeState.tlsSession);
        if (byArray.length > 0 && !Arrays.contains(clientHandshakeState.offeredCipherSuites, clientHandshakeState.sessionParameters.getCipherSuite())) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        ProtocolVersion protocolVersion3 = null;
        if (byArray.length > 0 && !ProtocolVersion.contains(protocolVersionArray, protocolVersion3 = clientHandshakeState.sessionParameters.getNegotiatedVersion())) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        if (byArray.length > 0 && TlsUtils.isExtendedMasterSecretOptional(protocolVersion3)) {
            if (bl6) {
                if (!clientHandshakeState.sessionParameters.isExtendedMasterSecret() && !tlsClient.allowLegacyResumption()) {
                    byArray = TlsUtils.EMPTY_BYTES;
                }
            } else if (clientHandshakeState.sessionParameters.isExtendedMasterSecret()) {
                byArray = TlsUtils.EMPTY_BYTES;
            }
        }
        if (byArray.length < 1) {
            this.cancelSession(clientHandshakeState);
        }
        tlsClient.notifySessionToResume(clientHandshakeState.tlsSession);
        ProtocolVersion protocolVersion4 = protocolVersion2;
        if (bl3) {
            protocolVersion4 = ProtocolVersion.DTLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionClient(clientHandshakeState.clientExtensions, protocolVersionArray);
        }
        tlsClientContextImpl.setRSAPreMasterSecretVersion(protocolVersion4);
        securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(clientHandshakeState.clientExtensions);
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion2)) {
            TlsUtils.establishClientSigAlgs(securityParameters, clientHandshakeState.clientExtensions);
        }
        securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(clientHandshakeState.clientExtensions);
        clientHandshakeState.clientBinders = null;
        clientHandshakeState.clientAgreements = TlsUtils.addKeyShareToClientHello(tlsClientContextImpl, tlsClient, clientHandshakeState.clientExtensions);
        if (bl6 && TlsUtils.isExtendedMasterSecretOptional(protocolVersionArray)) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(clientHandshakeState.clientExtensions);
        } else {
            clientHandshakeState.clientExtensions.remove(TlsExtensionsUtils.EXT_extended_master_secret);
        }
        int n = null == TlsUtils.getExtensionData(clientHandshakeState.clientExtensions, TlsProtocol.EXT_RenegotiationInfo) ? 1 : 0;
        boolean bl7 = bl = !Arrays.contains(clientHandshakeState.offeredCipherSuites, 255);
        if (n != 0 && bl) {
            clientHandshakeState.offeredCipherSuites = Arrays.append(clientHandshakeState.offeredCipherSuites, 255);
        }
        if (bl5 && !Arrays.contains(clientHandshakeState.offeredCipherSuites, 22016)) {
            clientHandshakeState.offeredCipherSuites = Arrays.append(clientHandshakeState.offeredCipherSuites, 22016);
        }
        clientHandshakeState.heartbeat = tlsClient.getHeartbeat();
        clientHandshakeState.heartbeatPolicy = tlsClient.getHeartbeatPolicy();
        if (null != clientHandshakeState.heartbeat || 1 == clientHandshakeState.heartbeatPolicy) {
            TlsExtensionsUtils.addHeartbeatExtension(clientHandshakeState.clientExtensions, new HeartbeatExtension(clientHandshakeState.heartbeatPolicy));
        }
        n = null == clientHandshakeState.clientBinders ? 0 : clientHandshakeState.clientBinders.bindersSize;
        ClientHello clientHello = new ClientHello(protocolVersion4, securityParameters.getClientRandom(), byArray, TlsUtils.EMPTY_BYTES, clientHandshakeState.offeredCipherSuites, clientHandshakeState.clientExtensions, n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        clientHello.encode(tlsClientContextImpl, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientKeyExchange(ClientHandshakeState clientHandshakeState) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        clientHandshakeState.keyExchange.generateClientKeyExchange(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void cancelSession(ClientHandshakeState clientHandshakeState) {
        if (clientHandshakeState.sessionMasterSecret != null) {
            clientHandshakeState.sessionMasterSecret.destroy();
            clientHandshakeState.sessionMasterSecret = null;
        }
        if (clientHandshakeState.sessionParameters != null) {
            clientHandshakeState.sessionParameters.clear();
            clientHandshakeState.sessionParameters = null;
        }
        clientHandshakeState.tlsSession = null;
    }

    protected boolean establishSession(ClientHandshakeState clientHandshakeState, TlsSession tlsSession) {
        clientHandshakeState.tlsSession = null;
        clientHandshakeState.sessionParameters = null;
        clientHandshakeState.sessionMasterSecret = null;
        if (null == tlsSession || !tlsSession.isResumable()) {
            return false;
        }
        SessionParameters sessionParameters = tlsSession.exportSessionParameters();
        if (null == sessionParameters) {
            return false;
        }
        ProtocolVersion protocolVersion = sessionParameters.getNegotiatedVersion();
        if (null == protocolVersion || !protocolVersion.isDTLS()) {
            return false;
        }
        if (!sessionParameters.isExtendedMasterSecret() && !TlsUtils.isExtendedMasterSecretOptional(protocolVersion)) {
            return false;
        }
        TlsCrypto tlsCrypto = clientHandshakeState.clientContext.getCrypto();
        TlsSecret tlsSecret = TlsUtils.getSessionMasterSecret(tlsCrypto, sessionParameters.getMasterSecret());
        if (null == tlsSecret) {
            return false;
        }
        clientHandshakeState.tlsSession = tlsSession;
        clientHandshakeState.sessionParameters = sessionParameters;
        clientHandshakeState.sessionMasterSecret = tlsSecret;
        return true;
    }

    protected void invalidateSession(ClientHandshakeState clientHandshakeState) {
        if (clientHandshakeState.tlsSession != null) {
            clientHandshakeState.tlsSession.invalidate();
        }
        this.cancelSession(clientHandshakeState);
    }

    protected void processCertificateRequest(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        if (null == clientHandshakeState.authentication) {
            throw new TlsFatalAlert(40);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CertificateRequest certificateRequest = CertificateRequest.parse(clientHandshakeState.clientContext, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        clientHandshakeState.certificateRequest = TlsUtils.validateCertificateRequest(certificateRequest, clientHandshakeState.keyExchange);
    }

    protected void processCertificateStatus(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.certificateStatus = CertificateStatus.parse(clientHandshakeState.clientContext, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected byte[] processHelloVerifyRequest(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        int n = ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(protocolVersion) ? 255 : 32;
        byte[] byArray2 = TlsUtils.readOpaque8(byteArrayInputStream, 0, n);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!protocolVersion.isEqualOrEarlierVersionOf(clientHandshakeState.clientContext.getClientVersion())) {
            throw new TlsFatalAlert(47);
        }
        return byArray2;
    }

    protected void processNewSessionTicket(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        clientHandshakeState.client.notifyNewSessionTicket(newSessionTicket);
    }

    protected void processServerCertificate(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        clientHandshakeState.authentication = TlsUtils.receiveServerCertificate(clientHandshakeState.clientContext, clientHandshakeState.client, new ByteArrayInputStream(byArray), clientHandshakeState.serverExtensions);
    }

    protected void processServerHello(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        Object object;
        Object object2;
        byte[] byArray2;
        byte[] byArray3;
        ProtocolVersion protocolVersion;
        TlsClient tlsClient = clientHandshakeState.client;
        TlsClientContextImpl tlsClientContextImpl = clientHandshakeState.clientContext;
        SecurityParameters securityParameters = tlsClientContextImpl.getSecurityParametersHandshake();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ServerHello serverHello = ServerHello.parse(byteArrayInputStream);
        Hashtable hashtable = serverHello.getExtensions();
        ProtocolVersion protocolVersion2 = serverHello.getVersion();
        ProtocolVersion protocolVersion3 = TlsExtensionsUtils.getSupportedVersionsExtensionServer(hashtable);
        if (null == protocolVersion3) {
            protocolVersion = protocolVersion2;
        } else {
            if (!ProtocolVersion.DTLSv12.equals(protocolVersion2) || !ProtocolVersion.DTLSv13.isEqualOrEarlierVersionOf(protocolVersion3)) {
                throw new TlsFatalAlert(47);
            }
            protocolVersion = protocolVersion3;
        }
        this.reportServerVersion(clientHandshakeState, protocolVersion);
        int[] nArray = clientHandshakeState.offeredCipherSuites;
        securityParameters.serverRandom = serverHello.getRandom();
        if (!tlsClientContextImpl.getClientVersion().equals(protocolVersion)) {
            TlsUtils.checkDowngradeMarker(protocolVersion, securityParameters.getServerRandom());
        }
        byte[] byArray4 = serverHello.getSessionID();
        securityParameters.sessionID = byArray4;
        tlsClient.notifySessionID(byArray4);
        boolean bl = securityParameters.resumedSession = byArray4.length > 0 && clientHandshakeState.tlsSession != null && Arrays.areEqual(byArray4, clientHandshakeState.tlsSession.getSessionID());
        if (securityParameters.isResumedSession() && (serverHello.getCipherSuite() != clientHandshakeState.sessionParameters.getCipherSuite() || !securityParameters.getNegotiatedVersion().equals(clientHandshakeState.sessionParameters.getNegotiatedVersion()))) {
            throw new TlsFatalAlert(47, "ServerHello parameters do not match resumed session");
        }
        int n = DTLSClientProtocol.validateSelectedCipherSuite(serverHello.getCipherSuite(), (short)47);
        if (!TlsUtils.isValidCipherSuiteSelection(nArray, n) || !TlsUtils.isValidVersionForCipherSuite(n, securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(47, "ServerHello selected invalid cipher suite");
        }
        TlsUtils.negotiatedCipherSuite(securityParameters, n);
        tlsClient.notifySelectedCipherSuite(n);
        clientHandshakeState.serverExtensions = hashtable;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                if (n2.equals(TlsProtocol.EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(clientHandshakeState.clientExtensions, n2)) {
                    throw new TlsFatalAlert(110);
                }
                if (!securityParameters.isResumedSession()) continue;
            }
        }
        if ((byArray3 = TlsUtils.getExtensionData(hashtable, TlsProtocol.EXT_RenegotiationInfo)) == null) {
            securityParameters.secureRenegotiation = false;
        } else {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual(byArray3, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        tlsClient.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        boolean bl2 = false;
        if (TlsExtensionsUtils.hasExtendedMasterSecretExtension(clientHandshakeState.clientExtensions)) {
            bl2 = TlsExtensionsUtils.hasExtendedMasterSecretExtension(hashtable);
            if (TlsUtils.isExtendedMasterSecretOptional(protocolVersion)) {
                if (!bl2 && tlsClient.requiresExtendedMasterSecret()) {
                    throw new TlsFatalAlert(40, "Extended Master Secret extension is required");
                }
            } else if (bl2) {
                throw new TlsFatalAlert(47, "Server sent an unexpected extended_master_secret extension negotiating " + protocolVersion);
            }
        }
        securityParameters.extendedMasterSecret = bl2;
        if (securityParameters.isResumedSession() && securityParameters.isExtendedMasterSecret() != clientHandshakeState.sessionParameters.isExtendedMasterSecret()) {
            throw new TlsFatalAlert(40, "Server resumed session with mismatched extended_master_secret negotiation");
        }
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(hashtable);
        securityParameters.applicationProtocolSet = true;
        if (ProtocolVersion.DTLSv12.equals(securityParameters.getNegotiatedVersion()) && (byArray2 = TlsExtensionsUtils.getConnectionIDExtension(hashtable)) != null) {
            object2 = TlsExtensionsUtils.getConnectionIDExtension(clientHandshakeState.clientExtensions);
            if (object2 == null) {
                throw new TlsFatalAlert(80);
            }
            securityParameters.connectionIDLocal = byArray2;
            securityParameters.connectionIDPeer = object2;
        }
        if (null == (object = TlsExtensionsUtils.getHeartbeatExtension(hashtable))) {
            clientHandshakeState.heartbeat = null;
            clientHandshakeState.heartbeatPolicy = (short)2;
        } else if (1 != ((HeartbeatExtension)object).getMode()) {
            clientHandshakeState.heartbeat = null;
        }
        object = clientHandshakeState.clientExtensions;
        object2 = hashtable;
        if (securityParameters.isResumedSession()) {
            object = null;
            object2 = clientHandshakeState.sessionParameters.readServerExtensions();
        }
        if (object2 != null && !object2.isEmpty()) {
            boolean bl3 = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)object2);
            if (bl3 && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = bl3;
            securityParameters.maxFragmentLength = TlsUtils.processMaxFragmentLengthExtension((Hashtable)object, (Hashtable)object2, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)object2);
            if (!securityParameters.isResumedSession()) {
                if (TlsUtils.hasExpectedEmptyExtensionData((Hashtable)object2, TlsExtensionsUtils.EXT_status_request_v2, (short)47)) {
                    securityParameters.statusRequestVersion = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData((Hashtable)object2, TlsExtensionsUtils.EXT_status_request, (short)47)) {
                    securityParameters.statusRequestVersion = 1;
                }
                securityParameters.clientCertificateType = TlsUtils.processClientCertificateTypeExtension((Hashtable)object, (Hashtable)object2, (short)47);
                securityParameters.serverCertificateType = TlsUtils.processServerCertificateTypeExtension((Hashtable)object, (Hashtable)object2, (short)47);
                clientHandshakeState.expectSessionTicket = TlsUtils.hasExpectedEmptyExtensionData((Hashtable)object2, TlsProtocol.EXT_SessionTicket, (short)47);
            }
        }
        if (object != null) {
            tlsClient.processServerExtensions((Hashtable)object2);
        }
    }

    protected void processServerKeyExchange(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.keyExchange.processServerKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processServerSupplementalData(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        clientHandshakeState.client.processServerSupplementalData(vector);
    }

    protected void reportServerVersion(ClientHandshakeState clientHandshakeState, ProtocolVersion protocolVersion) throws IOException {
        TlsClientContextImpl tlsClientContextImpl = clientHandshakeState.clientContext;
        SecurityParameters securityParameters = tlsClientContextImpl.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion2 = securityParameters.getNegotiatedVersion();
        if (null != protocolVersion2) {
            if (!protocolVersion2.equals(protocolVersion)) {
                throw new TlsFatalAlert(47);
            }
            return;
        }
        if (!ProtocolVersion.contains(tlsClientContextImpl.getClientSupportedVersions(), protocolVersion)) {
            throw new TlsFatalAlert(70);
        }
        securityParameters.negotiatedVersion = protocolVersion;
        TlsUtils.negotiatedVersionDTLSClient(tlsClientContextImpl, clientHandshakeState.client);
    }

    protected static byte[] patchClientHelloWithCookie(byte[] byArray, byte[] byArray2) throws IOException {
        int n = 34;
        short s = TlsUtils.readUint8(byArray, n);
        int n2 = n + 1 + s;
        int n3 = n2 + 1;
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        TlsUtils.checkUint8(byArray2.length);
        TlsUtils.writeUint8(byArray2.length, byArray3, n2);
        System.arraycopy(byArray2, 0, byArray3, n3, byArray2.length);
        System.arraycopy(byArray, n3, byArray3, n3 + byArray2.length, byArray.length - n3);
        return byArray3;
    }

    protected static class ClientHandshakeState {
        TlsClient client = null;
        TlsClientContextImpl clientContext = null;
        TlsSession tlsSession = null;
        SessionParameters sessionParameters = null;
        TlsSecret sessionMasterSecret = null;
        SessionParameters.Builder sessionParametersBuilder = null;
        int[] offeredCipherSuites = null;
        Hashtable clientExtensions = null;
        Hashtable serverExtensions = null;
        boolean expectSessionTicket = false;
        Hashtable clientAgreements = null;
        OfferedPsks.BindersConfig clientBinders = null;
        TlsKeyExchange keyExchange = null;
        TlsAuthentication authentication = null;
        CertificateStatus certificateStatus = null;
        CertificateRequest certificateRequest = null;
        TlsHeartbeat heartbeat = null;
        short heartbeatPolicy = (short)2;

        protected ClientHandshakeState() {
        }
    }
}

