/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;

public class PQCUtil {
    public static ASN1ObjectIdentifier getMLDSAObjectidentifier(int n) {
        switch (n) {
            case 2308: {
                return NISTObjectIdentifiers.id_ml_dsa_44;
            }
            case 2309: {
                return NISTObjectIdentifiers.id_ml_dsa_65;
            }
            case 2310: {
                return NISTObjectIdentifiers.id_ml_dsa_87;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getMLDSASignatureScheme(MLDSAParameters mLDSAParameters) {
        if (MLDSAParameters.ml_dsa_44 == mLDSAParameters) {
            return 2308;
        }
        if (MLDSAParameters.ml_dsa_65 == mLDSAParameters) {
            return 2309;
        }
        if (MLDSAParameters.ml_dsa_87 == mLDSAParameters) {
            return 2310;
        }
        throw new IllegalArgumentException();
    }

    public static boolean supportsMLDSA(AlgorithmIdentifier algorithmIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return algorithmIdentifier.getAlgorithm().equals(aSN1ObjectIdentifier) && algorithmIdentifier.getParameters() == null;
    }
}

