/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcaTlsRSASigner
implements TlsSigner {
    private final JcaTlsCrypto crypto;
    private final PrivateKey privateKey;
    private Signature rawSigner = null;

    public JcaTlsRSASigner(JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, PublicKey publicKey) {
        this(jcaTlsCrypto, privateKey);
    }

    public JcaTlsRSASigner(JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey) {
        if (null == jcaTlsCrypto) {
            throw new NullPointerException("crypto");
        }
        if (null == privateKey) {
            throw new NullPointerException("privateKey");
        }
        this.crypto = jcaTlsCrypto;
        this.privateKey = privateKey;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        try {
            byte[] byArray2;
            Object object;
            Signature signature = this.getRawSigner();
            if (signatureAndHashAlgorithm != null) {
                if (signatureAndHashAlgorithm.getSignature() != 1) {
                    throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
                }
                object = new AlgorithmIdentifier(TlsUtils.getOIDForHashAlgorithm(signatureAndHashAlgorithm.getHash()), DERNull.INSTANCE);
                byArray2 = new DigestInfo((AlgorithmIdentifier)object, byArray).getEncoded();
            } else {
                byArray2 = byArray;
            }
            signature.update(byArray2, 0, byArray2.length);
            object = signature.sign();
            return object;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
        }
        finally {
            this.rawSigner = null;
        }
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        if (signatureAndHashAlgorithm != null && 1 == signatureAndHashAlgorithm.getSignature() && JcaUtils.isSunMSCAPIProviderActive() && this.isSunMSCAPIRawSigner()) {
            return this.crypto.createStreamSigner(signatureAndHashAlgorithm, this.privateKey, true);
        }
        return null;
    }

    protected Signature getRawSigner() throws GeneralSecurityException {
        if (this.rawSigner == null) {
            this.rawSigner = this.crypto.getHelper().createSignature("NoneWithRSA");
            this.rawSigner.initSign(this.privateKey, this.crypto.getSecureRandom());
        }
        return this.rawSigner;
    }

    protected boolean isSunMSCAPIRawSigner() throws IOException {
        try {
            Signature signature = this.getRawSigner();
            return JcaUtils.isSunMSCAPIProvider(signature.getProvider());
        }
        catch (GeneralSecurityException generalSecurityException) {
            return true;
        }
    }
}

