/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_image_format")
public class CLImageFormat
extends Struct<CLImageFormat>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGE_CHANNEL_ORDER;
    public static final int IMAGE_CHANNEL_DATA_TYPE;

    protected CLImageFormat(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CLImageFormat create(long address, @Nullable ByteBuffer container) {
        return new CLImageFormat(address, container);
    }

    public CLImageFormat(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CLImageFormat.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_channel_order")
    public int image_channel_order() {
        return CLImageFormat.nimage_channel_order(this.address());
    }

    @NativeType(value="cl_channel_type")
    public int image_channel_data_type() {
        return CLImageFormat.nimage_channel_data_type(this.address());
    }

    public CLImageFormat image_channel_order(@NativeType(value="cl_channel_order") int value) {
        CLImageFormat.nimage_channel_order(this.address(), value);
        return this;
    }

    public CLImageFormat image_channel_data_type(@NativeType(value="cl_channel_type") int value) {
        CLImageFormat.nimage_channel_data_type(this.address(), value);
        return this;
    }

    public CLImageFormat set(int image_channel_order, int image_channel_data_type) {
        this.image_channel_order(image_channel_order);
        this.image_channel_data_type(image_channel_data_type);
        return this;
    }

    public CLImageFormat set(CLImageFormat src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CLImageFormat malloc() {
        return new CLImageFormat(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CLImageFormat calloc() {
        return new CLImageFormat(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CLImageFormat create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CLImageFormat(MemoryUtil.memAddress(container), container);
    }

    public static CLImageFormat create(long address) {
        return new CLImageFormat(address, null);
    }

    public static @Nullable CLImageFormat createSafe(long address) {
        return address == 0L ? null : new CLImageFormat(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CLImageFormat.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CLImageFormat.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CLImageFormat mallocStack() {
        return CLImageFormat.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLImageFormat callocStack() {
        return CLImageFormat.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLImageFormat mallocStack(MemoryStack stack) {
        return CLImageFormat.malloc(stack);
    }

    @Deprecated
    public static CLImageFormat callocStack(MemoryStack stack) {
        return CLImageFormat.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CLImageFormat.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CLImageFormat.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLImageFormat.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLImageFormat.calloc(capacity, stack);
    }

    public static CLImageFormat malloc(MemoryStack stack) {
        return new CLImageFormat(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CLImageFormat calloc(MemoryStack stack) {
        return new CLImageFormat(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nimage_channel_order(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGE_CHANNEL_ORDER);
    }

    public static int nimage_channel_data_type(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGE_CHANNEL_DATA_TYPE);
    }

    public static void nimage_channel_order(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGE_CHANNEL_ORDER, value);
    }

    public static void nimage_channel_data_type(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGE_CHANNEL_DATA_TYPE, value);
    }

    static {
        Struct.Layout layout = CLImageFormat.__struct(CLImageFormat.__member(4), CLImageFormat.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGE_CHANNEL_ORDER = layout.offsetof(0);
        IMAGE_CHANNEL_DATA_TYPE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLImageFormat, Buffer>
    implements NativeResource {
        private static final CLImageFormat ELEMENT_FACTORY = CLImageFormat.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CLImageFormat getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cl_channel_order")
        public int image_channel_order() {
            return CLImageFormat.nimage_channel_order(this.address());
        }

        @NativeType(value="cl_channel_type")
        public int image_channel_data_type() {
            return CLImageFormat.nimage_channel_data_type(this.address());
        }

        public Buffer image_channel_order(@NativeType(value="cl_channel_order") int value) {
            CLImageFormat.nimage_channel_order(this.address(), value);
            return this;
        }

        public Buffer image_channel_data_type(@NativeType(value="cl_channel_type") int value) {
            CLImageFormat.nimage_channel_data_type(this.address(), value);
            return this;
        }
    }
}

