/*
 * Decompiled with CFR 0.152.
 */
package osrs;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import osrs.RGBColor;
import osrs.RSSpritePixels;

public final class CustomItemSprites {
    private static final Logger logger = LoggerFactory.getLogger(CustomItemSprites.class);
    private static final String CUSTOM_SPRITES_FOLDER = "custom_sprites";
    private static final String CUSTOM_SPRITE_EXTENSION = ".png";
    private static final String CUSTOM_SPRITE_EXTENSION_GLOB = "*.png";
    private static final int CUSTOM_SPRITE_EXTENSION_LENGTH = ".png".length();
    private static final RGBColor TRANS_COLOR = new RGBColor(255, 0, 255);
    private static final Map<Integer, RSSpritePixels> itemId2Pixels = new HashMap<Integer, RSSpritePixels>();

    private CustomItemSprites() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Nullable
    public static RSSpritePixels getSpriteOverride(int itemId) {
        return itemId2Pixels.get(itemId);
    }

    public static void loadCustomItemSprites() {
        try {
            CustomItemSprites.loadCustomItemSprites(CUSTOM_SPRITES_FOLDER, CustomItemSprites.class.getClassLoader());
            logger.info("Loaded {} custom item sprites", (Object)itemId2Pixels.size());
        }
        catch (Exception e) {
            logger.error("Error loading custom item sprites", e);
        }
    }

    private static void loadCustomItemSprites(String folder, ClassLoader classLoader) throws IOException, URISyntaxException {
        block22: {
            URL url = classLoader.getResource(folder);
            if (url == null) {
                throw new IllegalStateException("Resource folder not found on classpath: " + folder);
            }
            String urlProtocol = url.getProtocol();
            if ("file".equals(urlProtocol)) {
                Path directory = Paths.get(url.toURI());
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, CUSTOM_SPRITE_EXTENSION_GLOB);){
                    for (Path path : directoryStream) {
                        CustomItemSprites.tryLoadCustomItemSprite(folder + "/" + String.valueOf(path.getFileName()), classLoader);
                    }
                }
            }
            URI jarUri = url.toURI();
            try (FileSystem fileSystem = CustomItemSprites.getOrCreateFs(jarUri);){
                Path directory = fileSystem.getPath("/" + folder, new String[0]);
                if (!Files.exists(directory, new LinkOption[0])) break block22;
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, CUSTOM_SPRITE_EXTENSION_GLOB);){
                    for (Path path : directoryStream) {
                        CustomItemSprites.tryLoadCustomItemSprite(folder + "/" + path.getFileName().toString(), classLoader);
                    }
                }
            }
        }
    }

    private static FileSystem getOrCreateFs(URI jarUri) throws IOException {
        try {
            return FileSystems.getFileSystem(jarUri);
        }
        catch (FileSystemNotFoundException e) {
            return FileSystems.newFileSystem(jarUri, Map.of());
        }
        catch (ProviderNotFoundException e) {
            URI wrapped = URI.create("jar:" + jarUri.toString());
            try {
                return FileSystems.getFileSystem(wrapped);
            }
            catch (FileSystemNotFoundException ex) {
                return FileSystems.newFileSystem(wrapped, Map.of());
            }
        }
    }

    private static void tryLoadCustomItemSprite(String classpathName, ClassLoader classLoader) throws IOException {
        int id;
        String base = classpathName.substring(classpathName.lastIndexOf(47) + 1);
        if (!base.endsWith(CUSTOM_SPRITE_EXTENSION)) {
            return;
        }
        String idStr = base.substring(0, base.length() - CUSTOM_SPRITE_EXTENSION_LENGTH);
        try {
            id = Integer.parseInt(idStr);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        try (InputStream inputStream = classLoader.getResourceAsStream(classpathName);){
            if (inputStream == null) {
                return;
            }
            RSSpritePixels spritePixels = CustomItemSprites.loadSpritePixels(inputStream);
            itemId2Pixels.put(id, spritePixels);
        }
    }

    private static RSSpritePixels loadSpritePixels(InputStream inputStream) throws IOException {
        BufferedImage image = ImageIO.read(inputStream);
        if (image == null) {
            throw new IOException("Unsupported/invalid image");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        RSSpritePixels spritePixels = new RSSpritePixels(width, height);
        image.getRGB(0, 0, width, height, spritePixels.pixels, 0, width);
        CustomItemSprites.applyTransparency(spritePixels.pixels);
        return spritePixels;
    }

    private static void applyTransparency(int[] pixels) {
        RGBColor transColor = TRANS_COLOR;
        int defaultTransRed = transColor.getRed();
        int defaultTransGreen = transColor.getGreen();
        int defaultTransBlue = transColor.getBlue();
        for (int i = 0; i < pixels.length; ++i) {
            int blue;
            int green;
            int red;
            int pixel = pixels[i];
            int alpha = pixel >>> 24 & 0xFF;
            if (alpha != 0 && ((red = pixel >>> 16 & 0xFF) != defaultTransRed || (green = pixel >>> 8 & 0xFF) != defaultTransGreen || (blue = pixel & 0xFF) != defaultTransBlue)) continue;
            pixels[i] = 0;
        }
    }
}

