/*
 * Decompiled with CFR 0.152.
 */
package osrs;

public class RGBColor {
    private final int rgb;
    private final int red;
    private final int green;
    private final int blue;

    public RGBColor(int rgb) {
        this.rgb = rgb;
        this.red = rgb >> 16 & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb & 0xFF;
    }

    public RGBColor(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.rgb = this.calculateRGB();
    }

    private int calculateRGB() {
        int rgb = this.red;
        rgb = (rgb << 8) + this.green;
        rgb = (rgb << 8) + this.blue;
        return rgb;
    }

    public int getRgb() {
        return this.rgb;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.rgb == ((RGBColor)o).rgb;
    }

    public int hashCode() {
        return this.rgb;
    }
}

